#include "LCDsh.h"

// SMT32-re optimalizált verzió
void lcdsh_wrbyte(uint8_t data, int16_t dly){    // 1 bájt adat vagy parancs küldése az LCD-nek, 2 I/O lábon
  for (uint8_t mask=128; mask ; mask >>=1){               // 8-szor fog lefutni                  
        if (mask & data) SET_CLK;  else CLEAR_CLK;     // clock lábbeállítása az adatbitnek megfelelõen
        delayMicroseconds(5);                          // 3µs várakozás, hogy a kondi feltöltödjön vagy kisüljön
        noInterrupts();                                // a felfutó él elõtt tiltani kell a megszakításokat
        CLEAR_CLK; SET_CLK ;                           // felfutó él az órajelben a "kondiban tárolt" bit beírásához a léptetõregiszterbe        
        interrupts();                                  // a felfutó él után ujra lehetnek megszakítások
  }//end for //ADATBITEK beállítva
  
  if (dly) CLEAR_CLK; else SET_CLK;                  //RS beállítása    
  SET_EN ; delayMicroseconds(2); CLEAR_EN;             //EN impulzus
  delayMicroseconds(28);                               //további késleltetés, hogy meglegyen a 43us/byte (a kijelző miatt kell)
  if (dly > 50) delayMicroseconds(dly-50);         //ha volt megadva várakozás, akkor várakozik (az LCD parancs befejezõdésére)  
}//end fv


void lcdsh_Init(){  
  pinMode(LCDSH_clock, OUTPUT);
  pinMode(LCDSH_en,    OUTPUT);                              //vezérlõlábak beállítása: kimenet
  lcdsh_wrbyte(B00111000,5000);                              //8bites mód, 2soros mód, 5msec várakozás
  lcdsh_wrbyte(B00001000,39);                                //disp. off, 50usec
  lcdsh_wrbyte(B00111000,39); lcdsh_wrbyte(B00111000,50);    //8bites mód, 2sor , duplán kell kiadni a parancsot
  lcdsh_wrbyte(B00001100,39);                                //disp. on, cursor off, blink off, 50usec
  lcdsh_wrbyte(B00000001,1600);                              //clear, 2msec
  lcdsh_wrbyte(B00000010,1600);                              //cursor home, 2msec
  lcdsh_wrbyte(B00000110,39);                                //entry mod increase, no shift, 50usec
  lcdsh_wrbyte(B10000000,39);                                //set DD ram address, 50usec
}//end fv

void lcdsh_str(char * s){                       //string kiírása
  for ( ; *s ; s++) lcdsh_wrbyte(*s);           //a ciklus karakterenként küldi az LCD-nek a szöveget
}//end fv

void lcdsh_str(char *s, uint8_t len){             //string kiírása, len karakteren (ha hosszabb levágja, ha rövidebb szóközzel kiegészíti)
  for ( ; *s && len; s++,len--) {lcdsh_wrbyte(*s); }
  for ( ;len; len--) lcdsh_wrbyte(32);
}//end fv

void lcdsh_Line1 (){                           //kurzor az elsõ sor elejére
  lcdsh_wrbyte(0x80,50);
}//end fv

void lcdsh_Line2 (){                           //kurzor a második sor elejére
  lcdsh_wrbyte(0xC0,50);
}//end fv

void lcdsh_Line3 (){                           //kurzor a második sor elejére
  lcdsh_wrbyte(0xC0,94);
}//end fv

void lcdsh_Line4 (){                           //kurzor a második sor elejére
  lcdsh_wrbyte(0xD4,50);
}//end fv

void lcdsh_Cursor (int8_t oszlop, int8_t sor){     //kurzor adoss sor (1,2,3,4)/oszlop (0 - 19) pozicióba
  switch (sor) {case 2: oszlop += 0x40; break; case 3: oszlop += 0x14; break; case 4: oszlop += 0x54; break; };
  lcdsh_wrbyte( oszlop|0x80,50 );// set RAM address
}//ed fv

void lcdsh_num(int32_t szam, int8_t hossz, int8_t tizedesek){  //egész szám kiírása, jobbra igazítva, az utolsó számjegyek tizedesként
char tmp[32];
char sign;
if (hossz<=0) return; //nulla vagy negatív hossz értéknek nincs értelme
if (szam<0){ szam ^= ~0; szam++; sign='-';} else {sign=' ';};// +- előjel
tmp[hossz] =0;  //karakterláncot lezáró nulla
while (hossz && tizedesek){ hossz--; tizedesek--; tmp[hossz] = (szam % 10)|48; szam /= 10; };//end while //tizedesjegyek kiírása
if (hossz && tmp[hossz]) {hossz--; tmp[hossz]='.';}; //tizedespont
if (hossz){ hossz--; tmp[hossz] = (szam % 10)|48; szam /= 10; };//end if //tizedes előtti számjegy
while(hossz && szam){ hossz--; tmp[hossz] = (szam % 10)|48; szam /= 10;}; //end while //tizedes előtti további számjegyek
if (hossz) {hossz--; tmp[hossz]=sign;};  //előjel kiírása
while(hossz){ hossz--;  tmp[hossz]=' '; };//end while //maradék rész teleírása szóközzel
lcdsh_str(tmp);  //kiírás
}//end fv


void lcdsh_Ekezet(){
const char CH[]={ 2 , 4 , 14 , 1 , 15 , 17 , 15 , 32,           /* á  0*/
                  2 , 4 , 14 , 17 , 31 , 16 , 14 , 32,          /* é  1*/
                  2 , 4 , 14 , 17 , 17 , 17 , 14 , 32,          /* ó  2*/
                 10 , 32 , 14 , 17 , 17 , 17 , 14 , 32,         /* ö  3*/
                 5 , 10 , 32 , 14 , 17 , 17 , 14 , 32,          /* ő  4*/
                 10 , 32 , 17 , 17 , 17 , 19 , 13 , 32,         /* ü  5*/
                 5 , 10 , 32 , 17 , 17 , 19 , 13 , 32,          /* ű  6*/
                 2 , 4 , 0 , 17 , 17 , 19 , 13 , 32};           /* ú  7*/



                 
 char c;
lcdsh_wrbyte(B01000000,50); //Set CGRAM  Address
for (c=0; c<64; c++) {lcdsh_wrbyte(CH[c]);} //adatok másolása

lcdsh_wrbyte(B10000000,50); //Set DDRAM  Address
}

void lcdsh_str2(char *s, byte len){//ékezetet is tartalmazó szöveg kiírása, len karakteren
  byte c,d;
  for (c=0 ; *s && (c<len); s++,c++) {
    if ((*s<126) && (*s>31)){
      lcdsh_wrbyte(*s);
    }else{
      const char ekezetes[]="áíűőüöúóéÁÍŰŐÜÖÚÓÉ\0";   
      for (d=0; ekezetes[d]; d+=2) 
         if ((*s == ekezetes[d]) && (*(s+1) == ekezetes[d+1])){          
           lcdsh_wrbyte("\0i\6\4\5\3\7\2\1\0I\6\4\5\3\7\2\1"[d/2]); //ha egyezést talál, erre cseréli
           //lcdsh_wrbyte("aiuououoeAIUOUOOUE"[d/2]); //ha egyezést talál, erre cseréli 
           //lcdsh_wrbyte("\0i\3\4\3\2uo\1\0I\5\6\5\6UO\7"[d/2]); //ha egyezést talál, erre cseréli      
           s++;
           break;
         };//end if
      //lcdsh_wrbyte(3);  
    }//else    
  }//for
  for ( ;c<len; c++) lcdsh_wrbyte(32);
}//end fv

void lcdsh_str3(char *s, byte len){  //len hossznál kisebb esetén középre igazított szöveg
byte c,d,len2;
len2=0;
for (c=0; s[c]; c++){  len2++;  if ((s[c]>127) || (s[c]<32)) if (s[c+1]) c++;  }//for  
if (len > len2){ len2 = (len-len2)/2; lcdsh_str(" ",len2); }
lcdsh_str2(s, len-len2);
}//end fv
