#include <Arduino.h>
//
// LCD kijelző vezérlése 2 vezetékkel, 74HCT595 léptetőregiszteren keresztül
// SMT32-re optimalizált verzió
//
// vezérlő lábak írás/olvasás definiálása, PB9 és PB8
#define LCDSH_clock PB8
#define LCDSH_en    PB9
#define SET_CLK    GPIOB->regs->BSRR = 1<<9 
#define CLEAR_CLK   GPIOB->regs->BRR = 1<<9
#define SET_EN    GPIOB->regs->BSRR = 1<<8
#define CLEAR_EN  GPIOB->regs->BRR = 1<<8

//próba spec karakterek a bontott LCD kijelzőn
#define FOK "\x00DF"
#define OMEGA "\x00F4"
#define MICRO "\x00E4"
#define SZUM "\x00F6"
#define SZPI "\x00F7"
#define BAL "\x007F"
#define JOBB "\x007E"
#define DIV "\x00FD"


void lcdsh_wrbyte(unsigned char data, int16_t dly=0);
void lcdsh_Init();
void lcdsh_str(char * s);   //c string kiírása
void lcdsh_str(char *s, uint8_t len); //c string kiírása, len karakteren (ha hosszabb levágja, ha rövidebb szóközzel kiegészíti)
void lcdsh_Line1(); //kurzor az elsõ sor elejére
void lcdsh_Line2(); //kurzor a 2. sor elejére
void lcdsh_Line3(); //kurzor a 3. sor elejére
void lcdsh_Line4(); //kurzor a 4. sor elejére
void lcdsh_Cursor (int8_t  oszlop, int8_t  sor); //kurzor adott sor (1,2,3,4)/oszlop (0 - 19) pozicióba
void lcdsh_num(int32_t szam, int8_t  hossz, int8_t tizedesek=0);  //egész szám kiírása, jobbra igazítva, az utosó számjegyek tizedesként (tizedesek nem kötelező)
void lcdsh_Ekezet(); //ékezetes karakterek betöltése
void lcdsh_str2(char *s, byte len);
void lcdsh_str3(char *s, byte len);
